/*
 * Decompiled with CFR 0.152.
 */
package com.shcm.util;

import com.shcm.bean.BalanceResult;
import com.shcm.bean.ReplyResult;
import com.shcm.bean.ReportResult;
import com.shcm.bean.SendResult;
import com.shcm.bean.UpdateResult;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

public class PublicUtils {
    public static String UrlEncode(String sName, String encodeing) {
        String sValue = "";
        if (sName == null) {
            return sValue;
        }
        try {
            sValue = encodeing == null ? URLEncoder.encode(sName, "UTF-8") : URLEncoder.encode(sName, encodeing);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sValue;
    }

    public static String joinArray(String[] mobileArray, String delim) {
        String sMobile = "";
        if (mobileArray == null || mobileArray.length == 0) {
            return sMobile;
        }
        String[] stringArray = mobileArray;
        int n = mobileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            sMobile = String.valueOf(sMobile) + m;
            sMobile = String.valueOf(sMobile) + delim;
            ++n2;
        }
        if (sMobile.endsWith(delim)) {
            sMobile = sMobile.substring(0, sMobile.length() - delim.length());
        }
        return sMobile;
    }

    public static int parseInt(String str, int def) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static double parseDouble(String str, double def) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static long parseLong(String str, long def) {
        try {
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Date parseDate(String str, String format) {
        Date d = null;
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(format);
            d = fmt.parse(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static String getRequestErrorMsg() {
        return "\u57df\u540d\u89e3\u6790\u9519\u8bef\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38";
    }

    public static String getErrorMsg(int result) {
        switch (result) {
            case 1: {
                return "\u64cd\u4f5c\u6210\u529f";
            }
            case 0: {
                return "\u5e10\u6237\u683c\u5f0f\u4e0d\u6b63\u786e";
            }
            case -1: {
                return "\u670d\u52a1\u5668\u62d2\u7edd";
            }
            case -2: {
                return "\u5bc6\u94a5\u4e0d\u6b63\u786e";
            }
            case -3: {
                return "\u5bc6\u94a5\u5df2\u9501\u5b9a";
            }
            case -4: {
                return "\u53c2\u6570\u4e0d\u6b63\u786e";
            }
            case -5: {
                return "\u65e0\u6b64\u5e10\u6237";
            }
            case -6: {
                return "\u5e10\u6237\u5df2\u9501\u5b9a\u6216\u5df2\u8fc7\u671f";
            }
            case -7: {
                return "\u5e10\u6237\u672a\u5f00\u542f\u63a5\u53e3\u53d1\u9001";
            }
            case -8: {
                return "\u4e0d\u53ef\u4f7f\u7528\u8be5\u901a\u9053\u7ec4";
            }
            case -9: {
                return "\u5e10\u6237\u4f59\u989d\u4e0d\u8db3";
            }
            case -10: {
                return "\u5185\u90e8\u9519\u8bef";
            }
            case -11: {
                return "\u6263\u8d39\u5931\u8d25";
            }
        }
        return "\u672a\u77e5\u9519\u8bef";
    }

    public static List<SendResult> parseResult(String xml) {
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        ArrayList<SendResult> listItem = new ArrayList<SendResult>();
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(source);
            Element root = doc.getRootElement();
            if (root != null) {
                SendResult sr = new SendResult();
                Attribute result = root.getAttribute("result");
                if (result != null) {
                    sr.setResult(PublicUtils.parseInt(result.getValue(), 0));
                    sr.setErrMsg(PublicUtils.getErrorMsg(sr.getResult()));
                }
                if (sr.getResult() > 0) {
                    List listResult = root.getChildren("Item");
                    for (Element e : listResult) {
                        SendResult t = new SendResult();
                        t.setResult(sr.getResult());
                        t.setErrMsg(sr.getErrMsg());
                        t.setCorpId(PublicUtils.parseLong(e.getAttributeValue("cid"), 0L));
                        t.setStaffId(PublicUtils.parseInt(e.getAttributeValue("sid"), 0));
                        t.setMsgId(PublicUtils.parseLong(e.getAttributeValue("msgid"), 0L));
                        t.setTotal(PublicUtils.parseInt(e.getAttributeValue("total"), 0));
                        t.setUnitPrice(PublicUtils.parseDouble(e.getAttributeValue("price"), 0.0));
                        int nRemain = 0;
                        double dRemain = PublicUtils.parseDouble(e.getAttributeValue("remain"), 0.0);
                        if (t.getUnitPrice() > 0.0) {
                            nRemain = (int)Math.round(dRemain / t.getUnitPrice());
                        }
                        t.setRemain(nRemain);
                        listItem.add(t);
                    }
                } else {
                    listItem.add(sr);
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return listItem;
    }

    public static BalanceResult parseBalance(String xml) {
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        BalanceResult t = new BalanceResult();
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(source);
            Element root = doc.getRootElement();
            if (root != null) {
                Element item;
                Attribute result = root.getAttribute("result");
                if (result != null) {
                    int nResult = PublicUtils.parseInt(result.getValue(), 0);
                    t.setResult(nResult);
                    t.setErrMsg(PublicUtils.getErrorMsg(nResult));
                }
                if (t.getResult() > 0 && (item = root.getChild("Item")) != null) {
                    t.setCorpId(PublicUtils.parseLong(item.getAttributeValue("cid"), 0L));
                    t.setStaffId(PublicUtils.parseInt(item.getAttributeValue("sid"), 0));
                    int nRemain = 0;
                    double dRemain = PublicUtils.parseDouble(item.getAttributeValue("remain"), 0.0);
                    nRemain = (int)Math.round(dRemain / 0.1);
                    t.setRemain(nRemain);
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return t;
    }

    public static UpdateResult parseAuthKey(String xml) {
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        UpdateResult t = new UpdateResult();
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(source);
            Element root = doc.getRootElement();
            if (root != null) {
                Element item;
                Attribute result = root.getAttribute("result");
                if (result != null) {
                    int nResult = PublicUtils.parseInt(result.getValue(), 0);
                    t.setResult(nResult);
                    t.setErrMsg(PublicUtils.getErrorMsg(nResult));
                }
                if (t.getResult() > 0 && (item = root.getChild("Item")) != null) {
                    t.setCorpId(PublicUtils.parseLong(item.getAttributeValue("cid"), 0L));
                    t.setStaffId(PublicUtils.parseInt(item.getAttributeValue("sid"), 0));
                    t.setAuthKey(item.getAttributeValue("authkey"));
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return t;
    }

    public static List<ReportResult> parseSendState(String xml) {
        ArrayList<ReportResult> listReport = new ArrayList<ReportResult>();
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        SAXBuilder builder = new SAXBuilder();
        try {
            Attribute result;
            Document doc = builder.build(source);
            Element root = doc.getRootElement();
            if (root != null && (result = root.getAttribute("result")) != null) {
                int nRet = PublicUtils.parseInt(result.getValue(), -102);
                if (nRet > 0) {
                    List listItem = root.getChildren("Item");
                    for (Element item : listItem) {
                        ReportResult t = new ReportResult();
                        t.setId(PublicUtils.parseInt(item.getAttributeValue("id"), 0));
                        t.setMsgId(PublicUtils.parseLong(item.getAttributeValue("msgid"), 0L));
                        t.setMobile(item.getAttributeValue("mobile"));
                        t.setStatus(PublicUtils.parseInt(item.getAttributeValue("result"), 0));
                        t.setDetail(item.getAttributeValue("return"));
                        listReport.add(t);
                    }
                } else {
                    System.out.println("parseSendState(" + nRet + ")");
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return listReport;
    }

    public static List<ReplyResult> parseReply(String xml) {
        ArrayList<ReplyResult> listReply = new ArrayList<ReplyResult>();
        StringReader read = new StringReader(xml);
        InputSource source = new InputSource(read);
        SAXBuilder builder = new SAXBuilder();
        try {
            Attribute result;
            Document doc = builder.build(source);
            Element root = doc.getRootElement();
            if (root != null && (result = root.getAttribute("result")) != null) {
                int nRet = PublicUtils.parseInt(result.getValue(), -102);
                if (nRet > 0) {
                    List listItem = root.getChildren("Item");
                    for (Element item : listItem) {
                        ReplyResult t = new ReplyResult();
                        t.setId(PublicUtils.parseInt(item.getAttributeValue("id"), 0));
                        t.setMsgId(PublicUtils.parseLong(item.getAttributeValue("msgid"), 0L));
                        long lTime = PublicUtils.parseLong(item.getAttributeValue("time"), 0L);
                        if (lTime > 0L) {
                            t.setReplyTime(new Date(lTime));
                        }
                        t.setMobile(item.getAttributeValue("mobile"));
                        t.setContent(item.getAttributeValue("content"));
                        listReply.add(t);
                    }
                } else {
                    System.out.println("parseReply(" + nRet + ")");
                }
            }
        }
        catch (JDOMException jDOMException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return listReply;
    }
}

