/*
 * Decompiled with CFR 0.152.
 */
package com.shcm.send;

import com.shcm.bean.BalanceResult;
import com.shcm.bean.SendResult;
import com.shcm.bean.UpdateResult;
import com.shcm.util.HttpUtils;
import com.shcm.util.PublicUtils;
import java.util.ArrayList;
import java.util.List;

public class OpenApi {
    private static String sOpenUrl = "http://smsapi.c123.cn/OpenPlatform/OpenApi";
    private static String sAccount = "";
    private static String sAuthKey = "";
    private static int nCgid = 0;
    private static int nCsid = 0;

    public static void initializeAccount(String url, String account, String authkey, int cgid, int csid) {
        sOpenUrl = url;
        sAccount = account;
        sAuthKey = authkey;
        nCgid = cgid;
        nCsid = csid;
    }

    public static String querySendOnce(String mobile, String content, int cgid, int csid, String time) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("action=sendOnce&ac=");
        sb.append(sAccount);
        sb.append("&authkey=");
        sb.append(sAuthKey);
        sb.append("&m=");
        sb.append(mobile);
        sb.append("&c=");
        sb.append(PublicUtils.UrlEncode(content, null));
        if (cgid > 0 || nCgid > 0) {
            sb.append("&cgid=");
            sb.append(cgid > 0 ? cgid : nCgid);
        }
        if (csid > 0 || nCsid > 0) {
            sb.append("&csid=");
            sb.append(csid > 0 ? csid : nCsid);
        }
        if (time != null) {
            sb.append("&t=");
            sb.append(time);
        }
        return HttpUtils.post(sOpenUrl, sb.toString(), "POST", "UTF-8");
    }

    public static String querySendBatch(String mobile, String content, int cgid, int csid, String time) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("action=sendBatch&ac=");
        sb.append(sAccount);
        sb.append("&authkey=");
        sb.append(sAuthKey);
        sb.append("&m=");
        sb.append(mobile);
        sb.append("&c=");
        sb.append(PublicUtils.UrlEncode(content, null));
        if (cgid > 0 || nCgid > 0) {
            sb.append("&cgid=");
            sb.append(cgid > 0 ? cgid : nCgid);
        }
        if (csid > 0 || nCsid > 0) {
            sb.append("&csid=");
            sb.append(csid > 0 ? csid : nCsid);
        }
        if (time != null) {
            sb.append("&t=");
            sb.append(time);
        }
        return HttpUtils.post(sOpenUrl, sb.toString(), "POST", "UTF-8");
    }

    public static String querySendParam(String mobile, String content, String[] paramArray, int cgid, int csid, String time) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("action=sendParam&ac=");
        sb.append(sAccount);
        sb.append("&authkey=");
        sb.append(sAuthKey);
        sb.append("&m=");
        sb.append(mobile);
        sb.append("&c=");
        sb.append(PublicUtils.UrlEncode(content, null));
        int nCount = Math.min(paramArray.length, 10);
        int i = 0;
        while (i < nCount) {
            if (paramArray[i] != null) {
                sb.append("&p");
                sb.append(i + 1);
                sb.append("=");
                sb.append(PublicUtils.UrlEncode(paramArray[i], null));
            }
            ++i;
        }
        if (cgid > 0 || nCgid > 0) {
            sb.append("&cgid=");
            sb.append(cgid > 0 ? cgid : nCgid);
        }
        if (csid > 0 || nCsid > 0) {
            sb.append("&csid=");
            sb.append(csid > 0 ? csid : nCsid);
        }
        if (time != null) {
            sb.append("&t=");
            sb.append(time);
        }
        return HttpUtils.post(sOpenUrl, sb.toString(), "POST", "UTF-8");
    }

    public static String queryBalance() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("action=getBalance&ac=");
        sb.append(sAccount);
        sb.append("&authkey=");
        sb.append(sAuthKey);
        return HttpUtils.post(sOpenUrl, sb.toString(), "GET", "UTF-8");
    }

    public static String postUpdateKey() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("action=updateKey&ac=");
        sb.append(sAccount);
        sb.append("&authkey=");
        sb.append(sAuthKey);
        return HttpUtils.post(sOpenUrl, sb.toString(), "GET", "UTF-8");
    }

    public static BalanceResult getBalance() {
        BalanceResult br = new BalanceResult();
        try {
            String sRet = OpenApi.queryBalance();
            br = PublicUtils.parseBalance(sRet);
        }
        catch (Exception e) {
            br.setResult(-101);
            br.setErrMsg(PublicUtils.getRequestErrorMsg());
        }
        return br;
    }

    public static UpdateResult updateKey() {
        UpdateResult ur = new UpdateResult();
        try {
            String sRet = OpenApi.postUpdateKey();
            return PublicUtils.parseAuthKey(sRet);
        }
        catch (Exception e) {
            ur.setResult(-101);
            ur.setErrMsg("\u57df\u540d\u89e3\u6790\u9519\u8bef\u6216\u8005\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38");
            return ur;
        }
    }

    public static List<SendResult> sendOnce(String mobile, String content, int cgid, int csid, String time) {
        ArrayList<SendResult> listItem = new ArrayList<SendResult>();
        try {
            String sRet = OpenApi.querySendOnce(mobile, content, cgid, csid, time);
            return PublicUtils.parseResult(sRet);
        }
        catch (Exception e) {
            SendResult t = new SendResult();
            t.setResult(-101);
            t.setErrMsg(PublicUtils.getRequestErrorMsg());
            listItem.add(t);
            return listItem;
        }
    }

    public static List<SendResult> sendOnce(String[] mobileArray, String content, int cgid, int csid, String time) {
        ArrayList<SendResult> listItem = new ArrayList<SendResult>();
        try {
            String mobile = PublicUtils.joinArray(mobileArray, ",");
            String sRet = OpenApi.querySendOnce(mobile, content, cgid, csid, time);
            return PublicUtils.parseResult(sRet);
        }
        catch (Exception e) {
            SendResult t = new SendResult();
            t.setResult(-101);
            t.setErrMsg(PublicUtils.getRequestErrorMsg());
            listItem.add(t);
            return null;
        }
    }

    public static List<SendResult> sendBatch(String mobile, String content, int cgid, int csid, String time) {
        ArrayList<SendResult> listItem = new ArrayList<SendResult>();
        try {
            String sRet = OpenApi.querySendBatch(mobile, content, cgid, csid, time);
            return PublicUtils.parseResult(sRet);
        }
        catch (Exception e) {
            SendResult t = new SendResult();
            t.setResult(-101);
            t.setErrMsg(PublicUtils.getRequestErrorMsg());
            listItem.add(t);
            return listItem;
        }
    }

    public static List<SendResult> sendBatch(String[] mobileArray, String[] contentArray, int cgid, int csid, String time) {
        ArrayList<SendResult> listItem = new ArrayList<SendResult>();
        try {
            String mobile = PublicUtils.joinArray(mobileArray, ",");
            String content = PublicUtils.joinArray(contentArray, "{|}");
            String sRet = OpenApi.querySendBatch(mobile, content, cgid, csid, time);
            return PublicUtils.parseResult(sRet);
        }
        catch (Exception e) {
            SendResult t = new SendResult();
            t.setResult(-101);
            t.setErrMsg(PublicUtils.getRequestErrorMsg());
            listItem.add(t);
            return listItem;
        }
    }

    public static List<SendResult> sendParam(String mobile, String content, String[] paramArray, int cgid, int csid, String time) {
        ArrayList<SendResult> listItem = new ArrayList<SendResult>();
        try {
            String sRet = OpenApi.querySendParam(mobile, content, paramArray, cgid, csid, time);
            return PublicUtils.parseResult(sRet);
        }
        catch (Exception e) {
            SendResult t = new SendResult();
            t.setResult(-101);
            t.setErrMsg(PublicUtils.getRequestErrorMsg());
            listItem.add(t);
            return listItem;
        }
    }

    public static List<SendResult> sendParam(String[] mobileArray, String content, String[] paramArray, int cgid, int csid, String time) {
        ArrayList<SendResult> listItem = new ArrayList<SendResult>();
        try {
            String mobile = PublicUtils.joinArray(mobileArray, ",");
            String sRet = OpenApi.querySendParam(mobile, content, paramArray, cgid, csid, time);
            return PublicUtils.parseResult(sRet);
        }
        catch (Exception e) {
            SendResult t = new SendResult();
            t.setResult(-101);
            t.setErrMsg(PublicUtils.getRequestErrorMsg());
            listItem.add(t);
            return listItem;
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

